/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.services.runtime.entity.s3obs;

import com.google.gson.annotations.SerializedName;
import com.huawei.services.runtime.entity.s3obs.IObsTriggerInfo;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

public class S3ObsTriggerEvent
implements IObsTriggerInfo {
    @SerializedName(value="Records")
    private S3Record[] record;

    public S3ObsTriggerEvent() {
    }

    public S3ObsTriggerEvent(S3Record[] record) {
        this.record = record;
    }

    public S3Record[] getRecord() {
        return this.record;
    }

    public void setRecord(S3Record[] record) {
        this.record = record;
    }

    public String toString() {
        return "ObsTriggerEvent{Records=" + Arrays.toString(this.record) + '}';
    }

    private Optional<S3Record[]> check() {
        if (this.record == null || this.record.length < 1) {
            throw new IllegalArgumentException("Record can't be null. ");
        }
        if (this.record.length > 1) {
            throw new IllegalArgumentException("Record's length is to long! ");
        }
        return Optional.of(this.record);
    }

    @Override
    public String getBucketName() {
        Optional<S3Record[]> s3Record = this.check();
        return s3Record.map(r -> r[0].getObs().getBucket().getName()).orElseThrow(IllegalArgumentException::new);
    }

    @Override
    public String getObjectKey() {
        Optional<S3Record[]> obsRecord = this.check();
        return obsRecord.map(r -> r[0].getObs().getObsobject().getKey()).orElseThrow(IllegalArgumentException::new);
    }

    @Override
    public String getEventName() {
        Optional<S3Record[]> s3Record = this.check();
        return s3Record.map(r -> r[0].getEventName()).orElseThrow(IllegalArgumentException::new);
    }

    public class ObsObject {
        private int size;
        private String key;
        private String eTag;
        private String versionId;
        private String sequencer;

        public ObsObject() {
        }

        public ObsObject(int size, String key, String eTag, String versionId, String sequencer) {
            this.size = size;
            this.key = key;
            this.eTag = eTag;
            this.versionId = versionId;
            this.sequencer = sequencer;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String geteTag() {
            return this.eTag;
        }

        public void seteTag(String eTag) {
            this.eTag = eTag;
        }

        public String getVersionId() {
            return this.versionId;
        }

        public void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public String getSequencer() {
            return this.sequencer;
        }

        public void setSequencer(String sequencer) {
            this.sequencer = sequencer;
        }

        public String toString() {
            return "ObsObject{size=" + this.size + ", key='" + this.key + '\'' + ", eTag='" + this.eTag + '\'' + ", versionId='" + this.versionId + '\'' + ", sequencer='" + this.sequencer + '\'' + '}';
        }
    }

    public class S3Bucket {
        private String name;
        private String arn;
        @SerializedName(value="ownerIdentity")
        private S3IdEntity idEntity;

        public S3Bucket() {
        }

        public S3Bucket(String name, String arn, S3IdEntity idEntity) {
            this.name = name;
            this.arn = arn;
            this.idEntity = idEntity;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getArn() {
            return this.arn;
        }

        public void setArn(String arn) {
            this.arn = arn;
        }

        public S3IdEntity getIdEntity() {
            return this.idEntity;
        }

        public void setIdEntity(S3IdEntity idEntity) {
            this.idEntity = idEntity;
        }

        public String toString() {
            return "Bucket{name='" + this.name + '\'' + ", arn='" + this.arn + '\'' + ", ownerIdentity=" + this.idEntity + '}';
        }
    }

    public class S3IdEntity {
        @SerializedName(value="PrincipalId")
        private String id;

        public S3IdEntity() {
        }

        public S3IdEntity(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String toString() {
            return "S3IdEntity{PrincipalId='" + this.id + '\'' + '}';
        }
    }

    public class S3Body {
        @SerializedName(value="s3SchemaVersion")
        private String version;
        private String configurationId;
        private S3Bucket bucket;
        @SerializedName(value="object")
        private ObsObject obsobject;

        public S3Body() {
        }

        public S3Body(String version, String configurationId, S3Bucket bucket, ObsObject obsobject) {
            this.version = version;
            this.configurationId = configurationId;
            this.bucket = bucket;
            this.obsobject = obsobject;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getConfigurationId() {
            return this.configurationId;
        }

        public void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        public S3Bucket getBucket() {
            return this.bucket;
        }

        public void setBucket(S3Bucket bucket) {
            this.bucket = bucket;
        }

        public ObsObject getObsobject() {
            return this.obsobject;
        }

        public void setObsobject(ObsObject obsobject) {
            this.obsobject = obsobject;
        }

        public String toString() {
            return "S3Body{s3SchemaVersion='" + this.version + '\'' + ", configurationId='" + this.configurationId + '\'' + ", bucket=" + this.bucket + ", object=" + this.obsobject + '}';
        }
    }

    public class RequestParameters {
        private String sourceIPAddress;

        public RequestParameters() {
        }

        public RequestParameters(String sourceIPAddress) {
            this.sourceIPAddress = sourceIPAddress;
        }

        public String getSourceIPAddress() {
            return this.sourceIPAddress;
        }

        public void setSourceIPAddress(String sourceIPAddress) {
            this.sourceIPAddress = sourceIPAddress;
        }

        public String toString() {
            return "RequestParameters{sourceIPAddress='" + this.sourceIPAddress + '\'' + '}';
        }
    }

    public class S3Record {
        private String eventVersion;
        private String eventSource;
        private String awsRegion;
        private String eventTime;
        private String eventName;
        private S3IdEntity userIdentity;
        private RequestParameters requestParameters;
        private Map<String, Object> responseElements;
        @SerializedName(value="s3")
        private S3Body s3obs;

        public S3Record() {
        }

        public S3Record(String eventVersion, String eventSource, String awsRegion, String eventTime, String eventName, S3IdEntity userIdentity, RequestParameters requestParameters, Map<String, Object> responseElements, S3Body s3obs) {
            this.eventVersion = eventVersion;
            this.eventSource = eventSource;
            this.awsRegion = awsRegion;
            this.eventTime = eventTime;
            this.eventName = eventName;
            this.userIdentity = userIdentity;
            this.requestParameters = requestParameters;
            this.responseElements = responseElements;
            this.s3obs = s3obs;
        }

        public String getEventVersion() {
            return this.eventVersion;
        }

        public void setEventVersion(String eventVersion) {
            this.eventVersion = eventVersion;
        }

        public String getEventSource() {
            return this.eventSource;
        }

        public void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        public String getAwsRegion() {
            return this.awsRegion;
        }

        public void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public String getEventTime() {
            return this.eventTime;
        }

        public void setEventTime(String eventTime) {
            this.eventTime = eventTime;
        }

        public String getEventName() {
            return this.eventName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public S3IdEntity getUserIdentity() {
            return this.userIdentity;
        }

        public void setUserIdentity(S3IdEntity userIdentity) {
            this.userIdentity = userIdentity;
        }

        public RequestParameters getRequestParameters() {
            return this.requestParameters;
        }

        public void setRequestParameters(RequestParameters requestParameters) {
            this.requestParameters = requestParameters;
        }

        public Map<String, Object> getResponseElements() {
            return this.responseElements;
        }

        public void setResponseElements(Map<String, Object> responseElements) {
            this.responseElements = responseElements;
        }

        public S3Body getObs() {
            return this.s3obs;
        }

        public void setObs(S3Body obs) {
            this.s3obs = obs;
        }

        public String toString() {
            return "ObsRecord{eventVersion='" + this.eventVersion + '\'' + ", eventSource='" + this.eventSource + '\'' + ", awsRegion='" + this.awsRegion + '\'' + ", eventTime='" + this.eventTime + '\'' + ", eventName='" + this.eventName + '\'' + ", userIdentity=" + this.userIdentity + ", requestParameters=" + this.requestParameters + ", responseElements=" + this.responseElements + ", s3=" + this.s3obs + '}';
        }
    }
}

