/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.services.runtime.entity.apig;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class APIGTriggerResponse {
    private static final int HTTP_OK = 200;
    private String body;
    private Map<String, String> headers;
    private int statusCode;
    private boolean isBase64Encoded;

    public APIGTriggerResponse() {
        this.statusCode = 200;
        this.body = "";
        this.isBase64Encoded = false;
    }

    public APIGTriggerResponse(int statusCode, Map<String, String> headers, String body) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.body = body;
        this.isBase64Encoded = false;
    }

    public APIGTriggerResponse(int statusCode, Map<String, String> headers, boolean isBase64Encoded, String body) {
        this.body = body;
        this.headers = headers;
        this.statusCode = statusCode;
        this.isBase64Encoded = isBase64Encoded;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setBase64EncodedBody(String body) throws UnsupportedEncodingException {
        this.body = Base64.getMimeEncoder().encodeToString(body.getBytes("UTF-8"));
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
    }

    public void removeHeader(String key) {
        if (this.headers != null) {
            this.headers.remove(key);
        }
    }

    public void addHeaders(Map<String, String> headersToAdd) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.putAll(headersToAdd);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public boolean isBase64Encoded() {
        return this.isBase64Encoded;
    }

    public void setBase64Encoded(boolean base64Encoded) {
        this.isBase64Encoded = base64Encoded;
    }
}

