/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.amqp.AmqpConnectorCommonConfiguration;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPExceptions;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPLogging;
import io.vertx.amqp.impl.AmqpConnectionImpl;
import io.vertx.mutiny.amqp.AmqpClient;
import io.vertx.mutiny.amqp.AmqpConnection;
import io.vertx.mutiny.core.Context;
import io.vertx.mutiny.core.Vertx;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.qpid.proton.amqp.Symbol;

public class ConnectionHolder {
    private final AmqpClient client;
    private final AmqpConnectorCommonConfiguration configuration;
    private final AtomicReference<CurrentConnection> holder = new AtomicReference();
    private final Vertx vertx;
    private Consumer<Throwable> callback;

    public ConnectionHolder(AmqpClient client, AmqpConnectorCommonConfiguration configuration, Vertx vertx) {
        this.client = client;
        this.configuration = configuration;
        this.vertx = vertx;
    }

    public Context getContext() {
        CurrentConnection connection = this.holder.get();
        if (connection != null) {
            return connection.context;
        }
        return null;
    }

    @CheckReturnValue
    public Uni<Boolean> isConnected() {
        CurrentConnection connection = this.holder.get();
        if (connection == null) {
            return Uni.createFrom().item((Object)false);
        }
        AmqpConnection underlying = connection.connection;
        if (underlying == null) {
            return Uni.createFrom().item((Object)false);
        }
        return Uni.createFrom().item(() -> !underlying.isDisconnected()).runSubscriptionOn(arg_0 -> ((Context)connection.context).runOnContext(arg_0));
    }

    public static List<String> capabilities(AmqpConnection connection) {
        Symbol[] capabilities = ((AmqpConnectionImpl)connection.getDelegate()).unwrap().getRemoteOfferedCapabilities();
        return Arrays.stream(capabilities).map(Symbol::toString).collect(Collectors.toList());
    }

    public static boolean supportAnonymousRelay(AmqpConnection connection) {
        return ConnectionHolder.capabilities(connection).contains("ANONYMOUS-RELAY");
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public int getHealthTimeout() {
        return this.configuration.getHealthTimeout();
    }

    public synchronized void onFailure(Consumer<Throwable> callback) {
        this.callback = callback;
    }

    @CheckReturnValue
    public Uni<AmqpConnection> getOrEstablishConnection() {
        return Uni.createFrom().item(() -> {
            CurrentConnection connection = this.holder.get();
            if (connection != null && connection.connection != null && !connection.connection.isDisconnected()) {
                return connection.connection;
            }
            return null;
        }).onItem().ifNull().switchTo(() -> {
            Integer retryInterval = this.configuration.getReconnectInterval();
            Integer retryAttempts = this.configuration.getReconnectAttempts();
            CurrentConnection reference = this.holder.get();
            if (reference != null && reference.connection != null && !reference.connection.isDisconnected()) {
                AmqpConnection connection = reference.connection;
                return Uni.createFrom().item((Object)connection);
            }
            return this.client.connect().onSubscription().invoke(s -> AMQPLogging.log.establishingConnection()).onItem().transform(conn -> {
                AMQPLogging.log.connectionEstablished();
                this.holder.set(new CurrentConnection((AmqpConnection)conn, Vertx.currentContext()));
                conn.exceptionHandler(t -> {
                    Consumer<Throwable> c;
                    this.holder.set(null);
                    AMQPLogging.log.connectionFailure((Throwable)t);
                    ConnectionHolder connectionHolder = this;
                    synchronized (connectionHolder) {
                        c = this.callback;
                    }
                    if (c != null) {
                        c.accept((Throwable)t);
                    }
                });
                if (conn.isDisconnected() || this.holder.get() == null) {
                    this.holder.set(null);
                    throw AMQPExceptions.ex.illegalStateConnectionDisconnected();
                }
                return conn;
            }).onFailure().invoke(AMQPLogging.log::unableToConnectToBroker).onFailure().retry().withBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(retryInterval.intValue())).atMost((long)retryAttempts.intValue()).onFailure().invoke(t -> {
                this.holder.set(null);
                AMQPLogging.log.unableToRecoverFromConnectionDisruption((Throwable)t);
            });
        });
    }

    public static CompletionStage<Void> runOnContext(Context context, Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (Vertx.currentContext() == context) {
            runnable.run();
            future.complete(null);
        } else {
            context.runOnContext(() -> {
                runnable.run();
                future.complete(null);
            });
        }
        return future;
    }

    public static CompletionStage<Void> runOnContextAndReportFailure(Context context, Throwable reason, Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (Vertx.currentContext() == context) {
            runnable.run();
            future.completeExceptionally(reason);
        } else {
            context.runOnContext(() -> {
                runnable.run();
                future.completeExceptionally(reason);
            });
        }
        return future;
    }

    private static class CurrentConnection {
        final AmqpConnection connection;
        final Context context;

        private CurrentConnection(AmqpConnection connection, Context context) {
            this.connection = connection;
            this.context = context;
        }
    }
}

