/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.tuples.Tuple2;
import io.smallrye.reactive.messaging.TracingMetadata;
import io.smallrye.reactive.messaging.amqp.AmqpConnector;
import io.smallrye.reactive.messaging.amqp.AmqpConnectorOutgoingConfiguration;
import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import io.smallrye.reactive.messaging.amqp.AmqpMessageConverter;
import io.smallrye.reactive.messaging.amqp.ConnectionHolder;
import io.smallrye.reactive.messaging.amqp.OutgoingAmqpMetadata;
import io.smallrye.reactive.messaging.amqp.ce.AmqpCloudEventHelper;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPExceptions;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPLogging;
import io.smallrye.reactive.messaging.amqp.tracing.HeaderInjectAdapter;
import io.smallrye.reactive.messaging.ce.OutgoingCloudEventMetadata;
import io.vertx.amqp.impl.AmqpMessageImpl;
import io.vertx.mutiny.amqp.AmqpSender;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class AmqpCreditBasedSender
implements Processor<Message<?>, Message<?>>,
Subscription {
    private final ConnectionHolder holder;
    private final Uni<AmqpSender> retrieveSender;
    private final AtomicLong requested = new AtomicLong();
    private final AmqpConnectorOutgoingConfiguration configuration;
    private final AmqpConnector connector;
    private final AtomicReference<Subscription> upstream = new AtomicReference();
    private final AtomicReference<Subscriber<? super Message<?>>> downstream = new AtomicReference();
    private final AtomicBoolean once = new AtomicBoolean();
    private final boolean durable;
    private final long ttl;
    private final String configuredAddress;
    private final boolean tracingEnabled;
    private final boolean mandatoryCloudEventAttributeSet;
    private final boolean writeCloudEvents;
    private final boolean writeAsBinaryCloudEvent;
    private final int retryAttempts;
    private final int retryInterval;
    private volatile boolean isAnonymous;

    public AmqpCreditBasedSender(AmqpConnector connector, ConnectionHolder holder, AmqpConnectorOutgoingConfiguration configuration, Uni<AmqpSender> retrieveSender) {
        this.connector = connector;
        this.holder = holder;
        this.retrieveSender = retrieveSender;
        this.configuration = configuration;
        this.durable = configuration.getDurable();
        this.ttl = configuration.getTtl();
        this.configuredAddress = configuration.getAddress().orElseGet(configuration::getChannel);
        this.tracingEnabled = configuration.getTracingEnabled();
        this.mandatoryCloudEventAttributeSet = configuration.getCloudEventsType().isPresent() && configuration.getCloudEventsSource().isPresent();
        this.writeCloudEvents = configuration.getCloudEvents();
        this.writeAsBinaryCloudEvent = configuration.getCloudEventsMode().equalsIgnoreCase("binary");
        this.retryAttempts = configuration.getReconnectAttempts();
        this.retryInterval = configuration.getReconnectInterval();
    }

    public void subscribe(Subscriber<? super Message<?>> subscriber) {
        if (!this.downstream.compareAndSet(null, subscriber)) {
            Subscriptions.fail(subscriber, (Throwable)AMQPExceptions.ex.illegalStateOnlyOneSubscriberAllowed());
        } else if (this.upstream.get() != null) {
            subscriber.onSubscribe((Subscription)this);
        }
    }

    private Uni<AmqpSender> getSenderAndCredits() {
        return this.retrieveSender.onItem().call(sender -> {
            this.isAnonymous = this.configuration.getUseAnonymousSender().orElseGet(() -> ConnectionHolder.supportAnonymousRelay(sender.connection()));
            CompletableFuture future = new CompletableFuture();
            this.holder.getContext().runOnContext(() -> {
                this.setCreditsAndRequest((AmqpSender)sender);
                future.complete(null);
            });
            return Uni.createFrom().completionStage(future);
        });
    }

    @CheckReturnValue
    public Uni<Boolean> isConnected() {
        return this.isConnected(true);
    }

    public int getHealthTimeout() {
        return this.configuration.getHealthTimeout();
    }

    private Uni<Boolean> isConnected(boolean attemptConnection) {
        return this.holder.isConnected().chain(ok -> {
            if (!ok.booleanValue() && attemptConnection) {
                return this.holder.getOrEstablishConnection().chain(x -> this.isConnected(false));
            }
            return Uni.createFrom().item(ok);
        });
    }

    public void onSubscribe(Subscription subscription) {
        if (this.upstream.compareAndSet(null, subscription)) {
            Subscriber<? super Message<?>> subscriber = this.downstream.get();
            if (subscriber != null) {
                subscriber.onSubscribe((Subscription)this);
            }
        } else {
            Subscriber<? super Message<?>> subscriber = this.downstream.get();
            if (subscriber != null) {
                subscriber.onSubscribe((Subscription)Subscriptions.CANCELLED);
            }
        }
    }

    private long setCreditsAndRequest(AmqpSender sender) {
        long credits = sender.remainingCredits();
        Subscription subscription = this.upstream.get();
        if (credits != 0L && subscription != Subscriptions.CANCELLED) {
            this.requested.set(credits);
            AMQPLogging.log.retrievedCreditsForChannel(this.configuration.getChannel(), credits);
            subscription.request(credits);
            return credits;
        }
        return 0L;
    }

    public void onNext(Message<?> message) {
        if (this.isCancelled()) {
            return;
        }
        Subscriber<? super Message<?>> subscriber = this.downstream.get();
        this.retrieveSender.onItem().transformToUni(sender -> {
            try {
                return this.send((AmqpSender)sender, message, this.durable, this.ttl, this.configuredAddress, this.isAnonymous).onItem().transform(m -> Tuple2.of((Object)sender, (Object)m));
            }
            catch (Exception e) {
                message.nack((Throwable)e);
                AMQPLogging.log.serializationFailure(this.configuration.getChannel(), e);
                return Uni.createFrom().nullItem();
            }
        }).subscribe().with(tuple -> {
            if (tuple != null) {
                subscriber.onNext(tuple.getItem2());
                if (this.requested.decrementAndGet() == 0L) {
                    this.onNoMoreCredit((AmqpSender)tuple.getItem1());
                }
            }
        }, arg_0 -> subscriber.onError(arg_0));
    }

    private void onNoMoreCredit(AmqpSender sender) {
        AMQPLogging.log.noMoreCreditsForChannel(this.configuration.getChannel());
        this.holder.getContext().runOnContext(() -> {
            if (this.isCancelled()) {
                return;
            }
            long c = this.setCreditsAndRequest(sender);
            if (c == 0L) {
                this.holder.getVertx().setPeriodic((long)this.configuration.getCreditRetrievalPeriod().intValue(), id -> {
                    if (this.setCreditsAndRequest(sender) != 0L || this.isCancelled()) {
                        this.holder.getVertx().cancelTimer(id.longValue());
                    }
                });
            }
        });
    }

    private boolean isCancelled() {
        Subscription subscription = this.upstream.get();
        return subscription == Subscriptions.CANCELLED || subscription == null;
    }

    public void onError(Throwable throwable) {
        Subscription sub = this.upstream.getAndSet((Subscription)Subscriptions.CANCELLED);
        Subscriber<? super Message<?>> subscriber = this.downstream.get();
        if (sub != null && sub != Subscriptions.CANCELLED && subscriber != null) {
            subscriber.onError(throwable);
        }
    }

    public void onComplete() {
        Subscription sub = this.upstream.getAndSet((Subscription)Subscriptions.CANCELLED);
        Subscriber<? super Message<?>> subscriber = this.downstream.get();
        if (sub != null && sub != Subscriptions.CANCELLED && subscriber != null) {
            subscriber.onComplete();
        }
    }

    public void request(long l) {
        if (!this.once.getAndSet(true)) {
            this.getSenderAndCredits().onItem().ignore().andContinueWithNull().subscribe().with(s -> {}, f -> this.downstream.get().onError(f));
        }
    }

    public void cancel() {
        Subscription sub = this.upstream.getAndSet((Subscription)Subscriptions.CANCELLED);
        if (sub != null && sub != Subscriptions.CANCELLED) {
            sub.cancel();
        }
    }

    private Uni<Message<?>> send(AmqpSender sender, Message<?> msg, boolean durable, long ttl, String configuredAddress, boolean isAnonymousSender) {
        io.vertx.mutiny.amqp.AmqpMessage amqp;
        OutgoingCloudEventMetadata ceMetadata = msg.getMetadata(OutgoingCloudEventMetadata.class).orElse(null);
        if (msg instanceof AmqpMessage) {
            amqp = ((AmqpMessage)msg).getAmqpMessage();
        } else if (msg.getPayload() instanceof io.vertx.mutiny.amqp.AmqpMessage) {
            amqp = (io.vertx.mutiny.amqp.AmqpMessage)msg.getPayload();
        } else if (msg.getPayload() instanceof io.vertx.amqp.AmqpMessage) {
            amqp = new io.vertx.mutiny.amqp.AmqpMessage((io.vertx.amqp.AmqpMessage)msg.getPayload());
        } else if (msg.getPayload() instanceof org.apache.qpid.proton.message.Message) {
            org.apache.qpid.proton.message.Message message = (org.apache.qpid.proton.message.Message)msg.getPayload();
            AmqpMessageImpl vertxMessage = new AmqpMessageImpl(message);
            amqp = new io.vertx.mutiny.amqp.AmqpMessage((io.vertx.amqp.AmqpMessage)vertxMessage);
        } else {
            amqp = AmqpMessageConverter.convertToAmqpMessage(msg, durable, ttl);
        }
        if (this.writeCloudEvents && (ceMetadata != null || this.mandatoryCloudEventAttributeSet)) {
            amqp = this.writeAsBinaryCloudEvent ? AmqpCloudEventHelper.createBinaryCloudEventMessage(amqp, ceMetadata, this.configuration) : AmqpCloudEventHelper.createStructuredEventMessage(amqp, ceMetadata, this.configuration);
        }
        String actualAddress = this.getActualAddress(msg, amqp, configuredAddress, isAnonymousSender);
        if (this.connector.getClients().isEmpty()) {
            AMQPLogging.log.messageNoSend(actualAddress);
            return Uni.createFrom().item(msg);
        }
        if (!actualAddress.equals(amqp.address())) {
            amqp.getDelegate().unwrap().setAddress(actualAddress);
        }
        this.createOutgoingTrace(msg, amqp);
        AMQPLogging.log.sendingMessageToAddress(actualAddress);
        return sender.sendWithAck(amqp).onFailure().retry().withBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(this.retryInterval)).atMost((long)this.retryAttempts).onItemOrFailure().transformToUni((success, failure) -> {
            if (failure != null) {
                return Uni.createFrom().completionStage(msg.nack(failure));
            }
            return Uni.createFrom().completionStage(msg.ack());
        }).onItem().transform(x -> msg);
    }

    private void createOutgoingTrace(Message<?> msg, io.vertx.mutiny.amqp.AmqpMessage amqp) {
        if (this.tracingEnabled) {
            Optional tracingMetadata = TracingMetadata.fromMessage(msg);
            SpanBuilder spanBuilder = AmqpConnector.TRACER.spanBuilder(amqp.address() + " send").setSpanKind(SpanKind.PRODUCER);
            if (tracingMetadata.isPresent()) {
                Context parentSpanContext = ((TracingMetadata)tracingMetadata.get()).getCurrentContext();
                if (parentSpanContext != null) {
                    spanBuilder.setParent(parentSpanContext);
                } else {
                    spanBuilder.setNoParent();
                }
            } else {
                spanBuilder.setNoParent();
            }
            Span span = spanBuilder.startSpan();
            Scope scope = span.makeCurrent();
            span.setAttribute(SemanticAttributes.MESSAGING_SYSTEM, (Object)"AMQP 1.0");
            span.setAttribute(SemanticAttributes.MESSAGING_DESTINATION, (Object)amqp.address());
            span.setAttribute(SemanticAttributes.MESSAGING_DESTINATION_KIND, (Object)"queue");
            span.setAttribute(SemanticAttributes.MESSAGING_PROTOCOL, (Object)"AMQP");
            span.setAttribute(SemanticAttributes.MESSAGING_PROTOCOL_VERSION, (Object)"1.0");
            GlobalOpenTelemetry.getPropagators().getTextMapPropagator().inject(Context.current(), (Object)amqp, (TextMapSetter)HeaderInjectAdapter.SETTER);
            span.end();
            scope.close();
        }
    }

    private String getActualAddress(Message<?> message, io.vertx.mutiny.amqp.AmqpMessage amqp, String configuredAddress, boolean isAnonymousSender) {
        String address = amqp.address();
        if (address != null) {
            if (isAnonymousSender) {
                return address;
            }
            AMQPLogging.log.unableToUseAddress(address, configuredAddress);
            return configuredAddress;
        }
        return message.getMetadata(OutgoingAmqpMetadata.class).flatMap(o -> {
            String addressFromMessage = o.getAddress();
            if (addressFromMessage != null && !isAnonymousSender) {
                AMQPLogging.log.unableToUseAddress(addressFromMessage, configuredAddress);
                return Optional.empty();
            }
            return Optional.ofNullable(addressFromMessage);
        }).orElse(configuredAddress);
    }
}

