/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;

public class ProtonReadableBufferImpl
implements ReadableBuffer {
    private ByteBuf buffer;

    public ProtonReadableBufferImpl(ByteBuf buffer) {
        this.buffer = buffer;
    }

    public ByteBuf getBuffer() {
        return this.buffer;
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    public ReadableBuffer reclaimRead() {
        return this;
    }

    public byte get() {
        return this.buffer.readByte();
    }

    public byte get(int index) {
        return this.buffer.getByte(index);
    }

    public int getInt() {
        return this.buffer.readInt();
    }

    public long getLong() {
        return this.buffer.readLong();
    }

    public short getShort() {
        return this.buffer.readShort();
    }

    public float getFloat() {
        return this.buffer.readFloat();
    }

    public double getDouble() {
        return this.buffer.readDouble();
    }

    public ReadableBuffer get(byte[] target, int offset, int length) {
        this.buffer.readBytes(target, offset, length);
        return this;
    }

    public ReadableBuffer get(byte[] target) {
        this.buffer.readBytes(target);
        return this;
    }

    public ReadableBuffer get(WritableBuffer target) {
        int start = target.position();
        if (this.buffer.hasArray()) {
            target.put(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.readerIndex(), this.buffer.readableBytes());
        } else {
            target.put(this.buffer.nioBuffer());
        }
        int written = target.position() - start;
        this.buffer.readerIndex(this.buffer.readerIndex() + written);
        return this;
    }

    public ReadableBuffer slice() {
        return new ProtonReadableBufferImpl(this.buffer.slice());
    }

    public ReadableBuffer flip() {
        this.buffer.setIndex(0, this.buffer.readerIndex());
        return this;
    }

    public ReadableBuffer limit(int limit) {
        this.buffer.writerIndex(limit);
        return this;
    }

    public int limit() {
        return this.buffer.writerIndex();
    }

    public ReadableBuffer position(int position) {
        this.buffer.readerIndex(position);
        return this;
    }

    public int position() {
        return this.buffer.readerIndex();
    }

    public ReadableBuffer mark() {
        this.buffer.markReaderIndex();
        return this;
    }

    public ReadableBuffer reset() {
        this.buffer.resetReaderIndex();
        return this;
    }

    public ReadableBuffer rewind() {
        this.buffer.readerIndex(0);
        return this;
    }

    public ReadableBuffer clear() {
        this.buffer.setIndex(0, this.buffer.capacity());
        return this;
    }

    public int remaining() {
        return this.buffer.readableBytes();
    }

    public boolean hasRemaining() {
        return this.buffer.isReadable();
    }

    public ReadableBuffer duplicate() {
        return new ProtonReadableBufferImpl(this.buffer.duplicate());
    }

    public ByteBuffer byteBuffer() {
        return this.buffer.nioBuffer();
    }

    public String readUTF8() throws CharacterCodingException {
        return this.buffer.toString(StandardCharsets.UTF_8);
    }

    public String readString(CharsetDecoder decoder) throws CharacterCodingException {
        return this.buffer.toString(StandardCharsets.UTF_8);
    }
}

