/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.InjectableReferenceProvider;
import io.quarkus.arc.impl.Qualifiers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;

public interface InjectableBean<T>
extends Bean<T>,
InjectableReferenceProvider<T> {
    public String getIdentifier();

    default public Kind getKind() {
        return Kind.CLASS;
    }

    default public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public Set<Type> getTypes();

    default public Set<Annotation> getQualifiers() {
        return Qualifiers.DEFAULT_QUALIFIERS;
    }

    default public void destroy(T instance, CreationalContext<T> creationalContext) {
        creationalContext.release();
    }

    default public InjectableBean<?> getDeclaringBean() {
        return null;
    }

    default public String getName() {
        return null;
    }

    default public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    default public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Deprecated
    default public boolean isNullable() {
        return false;
    }

    default public boolean isAlternative() {
        return false;
    }

    default public Integer getAlternativePriority() {
        return this.isAlternative() ? Integer.valueOf(this.getPriority()) : null;
    }

    default public boolean isDefaultBean() {
        return false;
    }

    default public boolean isSuppressed() {
        return false;
    }

    default public int getPriority() {
        return 0;
    }

    public static enum Kind {
        CLASS,
        PRODUCER_FIELD,
        PRODUCER_METHOD,
        SYNTHETIC,
        INTERCEPTOR,
        DECORATOR;


        public static Kind from(String value) {
            for (Kind kind : Kind.values()) {
                if (!kind.toString().equals(value)) continue;
                return kind;
            }
            return null;
        }
    }
}

