/*
 * Decompiled with CFR 0.152.
 */
package com.yovendo.printer.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.logging.Logger;

public class JsonMapper {
    private static Logger logger = Logger.getLogger(JsonMapper.class.getName());

    public static <T> T parse(String json, Class<T> classObject) {
        ObjectMapper objectMapper = new ObjectMapper();
        Object object = null;
        try {
            json = URLDecoder.decode(json, "UTF-8");
            object = objectMapper.readValue(json, classObject);
        }
        catch (IOException ex) {
            logger.severe(ex.getMessage());
        }
        return (T)object;
    }

    public static String stringify(Object object) {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = null;
        try {
            json = objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException ex) {
            logger.severe(ex.getMessage());
        }
        return json;
    }
}

