/*
 * Decompiled with CFR 0.152.
 */
package com.yovendo.printer.servicio.impl;

import com.yovendo.printer.client.ServiceBuilder;
import com.yovendo.printer.print.TrabajoImpresion;
import com.yovendo.printer.servicio.ImpresionServicio;
import com.yovendo.printer.util.JsonMapper;
import io.quarkus.arc.properties.IfBuildProperty;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;

@ApplicationScoped
@IfBuildProperty(name="imprimir.desde.mobil", stringValue="true")
public class QueComponent {
    @Inject
    private ServiceBuilder serviceBuilder;
    @Inject
    private ImpresionServicio impresionServicio;

    @Incoming(value="cola-print-in")
    public void imprimirReceive(String printData) {
        TrabajoImpresion trabajoImpresion = JsonMapper.parse(printData, TrabajoImpresion.class);
        Map<String, Object> parametros = trabajoImpresion.getArchivoImprimir().getParametros();
        Object esComandaObj = parametros.get("esComanda");
        if (esComandaObj != null && ((Boolean)esComandaObj).booleanValue()) {
            if (this.impresionServicio.imprimir(trabajoImpresion).booleanValue()) {
                this.serviceBuilder.updateComandDetailPrinter(trabajoImpresion.getToken(), trabajoImpresion.getUrlServidorActualizarDetalleComanda() + parametros.get("documentoId"));
            }
        } else {
            this.impresionServicio.imprimir(trabajoImpresion);
        }
    }
}

