/*
 * Decompiled with CFR 0.152.
 */
package com.yovendo.printer.servicio.impl;

import com.yovendo.printer.client.ServiceBuilder;
import com.yovendo.printer.print.Impresora;
import com.yovendo.printer.print.TrabajoImpresion;
import com.yovendo.printer.servicio.ContextoImpresion;
import com.yovendo.printer.servicio.EscritorArchivoServicio;
import com.yovendo.printer.servicio.ImpresionServicio;
import com.yovendo.printer.util.JsonMapper;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;

@ApplicationScoped
public class ImpresionServicioImpl
implements ImpresionServicio {
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    @Inject
    private ContextoImpresion contextoImpresion;
    @Inject
    private EscritorArchivoServicio escritorArchivoServicio;
    @Inject
    private ServiceBuilder serviceBuilder;

    public void imprimirReceive(String printData) {
        TrabajoImpresion trabajoImpresion = JsonMapper.parse(printData, TrabajoImpresion.class);
        Map<String, Object> parametros = trabajoImpresion.getArchivoImprimir().getParametros();
        Object esComandaObj = parametros.get("esComanda");
        if (esComandaObj != null && ((Boolean)esComandaObj).booleanValue()) {
            if (this.imprimir(trabajoImpresion).booleanValue()) {
                this.serviceBuilder.updateComandDetailPrinter(trabajoImpresion.getToken(), trabajoImpresion.getUrlServidorActualizarDetalleComanda() + parametros.get("documentoId"));
            }
        } else {
            this.imprimir(trabajoImpresion);
        }
    }

    @Override
    public List<Impresora> listarImpresoras() {
        this.contextoImpresion.leerImpresoras();
        return this.contextoImpresion.getListaImpresoras();
    }

    @Override
    public Impresora obtenerImpresoraDefault() {
        return this.contextoImpresion.getImpresoraDefault();
    }

    @Override
    public Impresora buscarImpresora(String nombreImpresora) {
        return this.contextoImpresion.buscarImpresora(nombreImpresora);
    }

    @Override
    public Boolean imprimir(TrabajoImpresion trabajo) {
        Boolean ok = Boolean.FALSE;
        String nombreImpresora = trabajo.getImpresora().getNombre();
        Impresora impresora = this.buscarImpresora(nombreImpresora);
        if (impresora == null) {
            this.logger.info("Impresora " + nombreImpresora + " no encontrada, intentando obtener impresora default...");
            impresora = this.obtenerImpresoraDefault();
            this.logger.info("impresora=" + impresora);
        }
        trabajo.setImpresora(impresora);
        HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
        printRequestAttributeSet.add(new JobName(trabajo.getArchivoImprimir().getNombreArchivo(), Locale.getDefault()));
        this.logger.info("Copias: " + trabajo.getNumeroCopias());
        try {
            this.logger.info("conectando al server inicio");
            Map<String, Object> parametros = trabajo.getArchivoImprimir().getParametros();
            String fileName = this.escritorArchivoServicio.escribirArchivo(this.serviceBuilder.getReport(parametros, "Bearer " + trabajo.getToken(), trabajo.getUrlServidorReporte()));
            try {
                this.logger.info("imprimiendo inicio");
                for (int i = 0; i < trabajo.getNumeroCopias(); ++i) {
                    try (PDDocument document = PDDocument.load((File)new File(fileName));){
                        PrintService myPrintService = this.contextoImpresion.obtenerServicio(trabajo.getImpresora().getNombre());
                        PrinterJob job = PrinterJob.getPrinterJob();
                        job.setPageable((Pageable)new PDFPageable(document));
                        job.setJobName(trabajo.getArchivoImprimir().getNombreArchivo());
                        job.setPrintService(myPrintService);
                        this.logger.info("Imprimiendo copia[" + (i + 1) + "]");
                        job.print();
                        this.logger.info("Fin impresion copia[" + (i + 1) + "]");
                        continue;
                    }
                }
                this.escritorArchivoServicio.eliminarArchivo(fileName);
                this.logger.info("imprimiendo fin");
                ok = Boolean.TRUE;
                Object esComandaObj = parametros.get("esComanda");
                if (esComandaObj != null && ((Boolean)esComandaObj).booleanValue()) {
                    this.serviceBuilder.updateComandDetailPrinter(trabajo.getToken(), trabajo.getUrlServidorActualizarDetalleComanda() + parametros.get("documentoId"));
                }
            }
            catch (PrinterException | IOException | NullPointerException ex) {
                this.logger.error((Object)ex, (Throwable)ex);
                ok = Boolean.FALSE;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        return ok;
    }

    @Override
    public String obtenerPcActual() {
        String terminal;
        try {
            terminal = InetAddress.getLocalHost().getHostName().toUpperCase();
        }
        catch (UnknownHostException ex) {
            terminal = "";
            this.logger.error((Object)ex, (Throwable)ex);
        }
        return terminal;
    }
}

