/*
 * Decompiled with CFR 0.152.
 */
package com.yovendo.printer.servicio.impl;

import com.yovendo.printer.print.SistemaImpresion;
import com.yovendo.printer.servicio.EscritorArchivoServicio;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ApplicationScoped
public class EscritorArchivoServicioImpl
implements EscritorArchivoServicio {
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String escribirArchivo(byte[] archivo) {
        String rutaArchivo;
        OutputStream stream = null;
        try {
            String rutaCarpeta = SistemaImpresion.obtenerRutaBase() + File.separator + ".goodideaprints";
            File carpeta = new File(rutaCarpeta);
            if (!carpeta.exists()) {
                carpeta.mkdirs();
            }
            rutaArchivo = rutaCarpeta + File.separator + System.currentTimeMillis() + ".pdf";
            stream = new FileOutputStream(new File(rutaArchivo));
            stream.write(archivo);
        }
        catch (IOException ex) {
            rutaArchivo = null;
            this.logger.error((Object)ex, (Throwable)ex);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ex) {
                this.logger.error((Object)ex, (Throwable)ex);
            }
        }
        return rutaArchivo;
    }

    @Override
    public Boolean eliminarArchivo(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            return file.delete();
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String escribirArchivo(InputStream archivo) {
        String rutaArchivo;
        OutputStream outputStream = null;
        try {
            int read;
            String rutaCarpeta = SistemaImpresion.obtenerRutaBase() + File.separator + ".goodideaprints";
            File carpeta = new File(rutaCarpeta);
            if (!carpeta.exists()) {
                carpeta.mkdirs();
            }
            rutaArchivo = rutaCarpeta + File.separator + UUID.randomUUID() + ".pdf";
            outputStream = new FileOutputStream(rutaArchivo);
            byte[] bytes = new byte[1024];
            while ((read = archivo.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            rutaArchivo = null;
            this.logger.error((Object)e, (Throwable)e);
        }
        finally {
            if (archivo != null) {
                try {
                    archivo.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)e, (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)e, (Throwable)e);
                }
            }
        }
        return rutaArchivo;
    }
}

