/*
 * Decompiled with CFR 0.152.
 */
package com.yovendo.printer.servicio.impl;

import com.yovendo.printer.print.Impresora;
import com.yovendo.printer.print.SistemaImpresion;
import com.yovendo.printer.print.TrabajoImpresion;
import com.yovendo.printer.servicio.ContextoImpresion;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ApplicationScoped
public class ContextoImpresionImpl
implements ContextoImpresion {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Inject
    private SistemaImpresion sistemaImpresion;

    public ContextoImpresionImpl() {
        this.logger.info("ContextoImpresionImpl constuctor...");
    }

    @PostConstruct
    private void postConstruct() {
        this.leerImpresoras();
    }

    @Override
    public void iniciarContexto() {
        this.leerImpresoras();
    }

    @Override
    public void leerImpresoras() {
        PrintService[] services;
        ArrayList<Impresora> nuevasImpresoras = new ArrayList<Impresora>();
        for (PrintService printService : services = PrintServiceLookup.lookupPrintServices(null, null)) {
            PrintServiceAttributeSet printServiceAttributeSet = printService.getAttributes();
            Impresora impresora = new Impresora();
            impresora.setEstado("" + printServiceAttributeSet.get(PrinterState.class));
            impresora.setNombre(printService.getName());
            nuevasImpresoras.add(impresora);
            this.logger.info("Impresora " + printService.getName() + " encontrada.");
        }
        this.sistemaImpresion.actualizarListaImpresoras(nuevasImpresoras);
    }

    @Override
    public List<Impresora> getListaImpresoras() {
        return this.sistemaImpresion.getListaImpresoras();
    }

    @Override
    public Impresora getImpresoraDefault() {
        String res = null;
        PrintService service = PrintServiceLookup.lookupDefaultPrintService();
        if (service != null) {
            res = service.getName();
        }
        return this.buscarImpresora(res);
    }

    @Override
    public Impresora buscarImpresora(String nombreImpresora) {
        for (Impresora impresora : this.sistemaImpresion.getListaImpresoras()) {
            if (!impresora.getNombre().equals(nombreImpresora)) continue;
            return impresora;
        }
        return null;
    }

    @Override
    public TrabajoImpresion buscarArchivo(String nombreArchivo) {
        for (TrabajoImpresion trabajoImpresion : this.sistemaImpresion.getListaTrabajosImpresion()) {
            if (!trabajoImpresion.getArchivoImprimir().getNombreArchivo().equals(nombreArchivo)) continue;
            return trabajoImpresion;
        }
        return null;
    }

    @Override
    public PrintService obtenerServicio(String impresora) {
        PrintService[] services;
        for (PrintService printService : services = PrintServiceLookup.lookupPrintServices(null, null)) {
            if (!printService.getName().equals(impresora)) continue;
            return printService;
        }
        return null;
    }
}

