/*
 * Decompiled with CFR 0.152.
 */
package com.yovendo.printer.client;

import com.yovendo.printer.client.DocumentService;
import com.yovendo.printer.client.ReportService;
import java.io.InputStream;
import java.net.Socket;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.ws.rs.core.Response;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.jboss.logging.Logger;

@ApplicationScoped
public class ServiceBuilder {
    private final Logger logger = Logger.getLogger(this.getClass());

    public InputStream getReport(Map<String, Object> body, String authorization, String url) {
        this.logger.info((Object)("body=" + body));
        this.logger.info((Object)("url=" + url));
        ReportService reportService = (ReportService)RestClientBuilder.newBuilder().baseUri(URI.create(url)).hostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).connectTimeout(1L, TimeUnit.MINUTES).sslContext(ServiceBuilder.trustEverything()).build(ReportService.class);
        Response response = reportService.getReport(body, authorization);
        return (InputStream)response.readEntity(InputStream.class);
    }

    public InputStream updateComandDetailPrinter(String authorization, String url) {
        this.logger.info((Object)("authorization=" + authorization));
        this.logger.info((Object)("url=" + url));
        DocumentService reportService = (DocumentService)RestClientBuilder.newBuilder().baseUri(URI.create(url)).hostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).sslContext(ServiceBuilder.trustEverything()).connectTimeout(1L, TimeUnit.MINUTES).build(DocumentService.class);
        Response response = reportService.updateComandDetailPrinter(authorization, "application/json");
        return (InputStream)response.readEntity(InputStream.class);
    }

    private static SSLContext trustEverything() {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, ServiceBuilder.trustAllCerts(), new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            return sc;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private static TrustManager[] trustAllCerts() {
        return new TrustManager[]{new X509ExtendedTrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            }
        }};
    }
}

